// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The CORS policy for the Cosmos DB database account.
 */
@Fluent
public final class CorsPolicy implements JsonSerializable<CorsPolicy> {
    /*
     * The origin domains that are permitted to make a request against the service via CORS.
     */
    private String allowedOrigins;

    /*
     * The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    private String allowedMethods;

    /*
     * The request headers that the origin domain may specify on the CORS request.
     */
    private String allowedHeaders;

    /*
     * The response headers that may be sent in the response to the CORS request and exposed by the browser to the
     * request issuer.
     */
    private String exposedHeaders;

    /*
     * The maximum amount time that a browser should cache the preflight OPTIONS request.
     */
    private Long maxAgeInSeconds;

    /**
     * Creates an instance of CorsPolicy class.
     */
    public CorsPolicy() {
    }

    /**
     * Get the allowedOrigins property: The origin domains that are permitted to make a request against the service via
     * CORS.
     * 
     * @return the allowedOrigins value.
     */
    public String allowedOrigins() {
        return this.allowedOrigins;
    }

    /**
     * Set the allowedOrigins property: The origin domains that are permitted to make a request against the service via
     * CORS.
     * 
     * @param allowedOrigins the allowedOrigins value to set.
     * @return the CorsPolicy object itself.
     */
    public CorsPolicy withAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    /**
     * Get the allowedMethods property: The methods (HTTP request verbs) that the origin domain may use for a CORS
     * request.
     * 
     * @return the allowedMethods value.
     */
    public String allowedMethods() {
        return this.allowedMethods;
    }

    /**
     * Set the allowedMethods property: The methods (HTTP request verbs) that the origin domain may use for a CORS
     * request.
     * 
     * @param allowedMethods the allowedMethods value to set.
     * @return the CorsPolicy object itself.
     */
    public CorsPolicy withAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    /**
     * Get the allowedHeaders property: The request headers that the origin domain may specify on the CORS request.
     * 
     * @return the allowedHeaders value.
     */
    public String allowedHeaders() {
        return this.allowedHeaders;
    }

    /**
     * Set the allowedHeaders property: The request headers that the origin domain may specify on the CORS request.
     * 
     * @param allowedHeaders the allowedHeaders value to set.
     * @return the CorsPolicy object itself.
     */
    public CorsPolicy withAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    /**
     * Get the exposedHeaders property: The response headers that may be sent in the response to the CORS request and
     * exposed by the browser to the request issuer.
     * 
     * @return the exposedHeaders value.
     */
    public String exposedHeaders() {
        return this.exposedHeaders;
    }

    /**
     * Set the exposedHeaders property: The response headers that may be sent in the response to the CORS request and
     * exposed by the browser to the request issuer.
     * 
     * @param exposedHeaders the exposedHeaders value to set.
     * @return the CorsPolicy object itself.
     */
    public CorsPolicy withExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    /**
     * Get the maxAgeInSeconds property: The maximum amount time that a browser should cache the preflight OPTIONS
     * request.
     * 
     * @return the maxAgeInSeconds value.
     */
    public Long maxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    /**
     * Set the maxAgeInSeconds property: The maximum amount time that a browser should cache the preflight OPTIONS
     * request.
     * 
     * @param maxAgeInSeconds the maxAgeInSeconds value to set.
     * @return the CorsPolicy object itself.
     */
    public CorsPolicy withMaxAgeInSeconds(Long maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (allowedOrigins() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property allowedOrigins in model CorsPolicy"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CorsPolicy.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("allowedOrigins", this.allowedOrigins);
        jsonWriter.writeStringField("allowedMethods", this.allowedMethods);
        jsonWriter.writeStringField("allowedHeaders", this.allowedHeaders);
        jsonWriter.writeStringField("exposedHeaders", this.exposedHeaders);
        jsonWriter.writeNumberField("maxAgeInSeconds", this.maxAgeInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CorsPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CorsPolicy if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CorsPolicy.
     */
    public static CorsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CorsPolicy deserializedCorsPolicy = new CorsPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedOrigins".equals(fieldName)) {
                    deserializedCorsPolicy.allowedOrigins = reader.getString();
                } else if ("allowedMethods".equals(fieldName)) {
                    deserializedCorsPolicy.allowedMethods = reader.getString();
                } else if ("allowedHeaders".equals(fieldName)) {
                    deserializedCorsPolicy.allowedHeaders = reader.getString();
                } else if ("exposedHeaders".equals(fieldName)) {
                    deserializedCorsPolicy.exposedHeaders = reader.getString();
                } else if ("maxAgeInSeconds".equals(fieldName)) {
                    deserializedCorsPolicy.maxAgeInSeconds = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCorsPolicy;
        });
    }
}
