// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB client encryption key resource object.
 */
@Fluent
public class ClientEncryptionKeyResource implements JsonSerializable<ClientEncryptionKeyResource> {
    /*
     * Name of the ClientEncryptionKey
     */
    private String id;

    /*
     * Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data.
     */
    private String encryptionAlgorithm;

    /*
     * Wrapped (encrypted) form of the key represented as a byte array.
     */
    private byte[] wrappedDataEncryptionKey;

    /*
     * Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key.
     */
    private KeyWrapMetadata keyWrapMetadata;

    /**
     * Creates an instance of ClientEncryptionKeyResource class.
     */
    public ClientEncryptionKeyResource() {
    }

    /**
     * Get the id property: Name of the ClientEncryptionKey.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the ClientEncryptionKey.
     * 
     * @param id the id value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the encryptionAlgorithm property: Encryption algorithm that will be used along with this client encryption
     * key to encrypt/decrypt data.
     * 
     * @return the encryptionAlgorithm value.
     */
    public String encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    /**
     * Set the encryptionAlgorithm property: Encryption algorithm that will be used along with this client encryption
     * key to encrypt/decrypt data.
     * 
     * @param encryptionAlgorithm the encryptionAlgorithm value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    /**
     * Get the wrappedDataEncryptionKey property: Wrapped (encrypted) form of the key represented as a byte array.
     * 
     * @return the wrappedDataEncryptionKey value.
     */
    public byte[] wrappedDataEncryptionKey() {
        return CoreUtils.clone(this.wrappedDataEncryptionKey);
    }

    /**
     * Set the wrappedDataEncryptionKey property: Wrapped (encrypted) form of the key represented as a byte array.
     * 
     * @param wrappedDataEncryptionKey the wrappedDataEncryptionKey value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        this.wrappedDataEncryptionKey = CoreUtils.clone(wrappedDataEncryptionKey);
        return this;
    }

    /**
     * Get the keyWrapMetadata property: Metadata for the wrapping provider that can be used to unwrap the wrapped
     * client encryption key.
     * 
     * @return the keyWrapMetadata value.
     */
    public KeyWrapMetadata keyWrapMetadata() {
        return this.keyWrapMetadata;
    }

    /**
     * Set the keyWrapMetadata property: Metadata for the wrapping provider that can be used to unwrap the wrapped
     * client encryption key.
     * 
     * @param keyWrapMetadata the keyWrapMetadata value to set.
     * @return the ClientEncryptionKeyResource object itself.
     */
    public ClientEncryptionKeyResource withKeyWrapMetadata(KeyWrapMetadata keyWrapMetadata) {
        this.keyWrapMetadata = keyWrapMetadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyWrapMetadata() != null) {
            keyWrapMetadata().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("encryptionAlgorithm", this.encryptionAlgorithm);
        jsonWriter.writeBinaryField("wrappedDataEncryptionKey", this.wrappedDataEncryptionKey);
        jsonWriter.writeJsonField("keyWrapMetadata", this.keyWrapMetadata);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientEncryptionKeyResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientEncryptionKeyResource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientEncryptionKeyResource.
     */
    public static ClientEncryptionKeyResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientEncryptionKeyResource deserializedClientEncryptionKeyResource = new ClientEncryptionKeyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.id = reader.getString();
                } else if ("encryptionAlgorithm".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.encryptionAlgorithm = reader.getString();
                } else if ("wrappedDataEncryptionKey".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.wrappedDataEncryptionKey = reader.getBinary();
                } else if ("keyWrapMetadata".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.keyWrapMetadata = KeyWrapMetadata.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientEncryptionKeyResource;
        });
    }
}
