// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ClientEncryptionKeyGetPropertiesResource model.
 */
@Fluent
public final class ClientEncryptionKeyGetPropertiesResource extends ClientEncryptionKeyResource {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of ClientEncryptionKeyGetPropertiesResource class.
     */
    public ClientEncryptionKeyGetPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClientEncryptionKeyGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClientEncryptionKeyGetPropertiesResource withEncryptionAlgorithm(String encryptionAlgorithm) {
        super.withEncryptionAlgorithm(encryptionAlgorithm);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClientEncryptionKeyGetPropertiesResource withWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        super.withWrappedDataEncryptionKey(wrappedDataEncryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClientEncryptionKeyGetPropertiesResource withKeyWrapMetadata(KeyWrapMetadata keyWrapMetadata) {
        super.withKeyWrapMetadata(keyWrapMetadata);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (keyWrapMetadata() != null) {
            keyWrapMetadata().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("encryptionAlgorithm", encryptionAlgorithm());
        jsonWriter.writeBinaryField("wrappedDataEncryptionKey", wrappedDataEncryptionKey());
        jsonWriter.writeJsonField("keyWrapMetadata", keyWrapMetadata());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientEncryptionKeyGetPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientEncryptionKeyGetPropertiesResource if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientEncryptionKeyGetPropertiesResource.
     */
    public static ClientEncryptionKeyGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientEncryptionKeyGetPropertiesResource deserializedClientEncryptionKeyGetPropertiesResource
                = new ClientEncryptionKeyGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.withId(reader.getString());
                } else if ("encryptionAlgorithm".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.withEncryptionAlgorithm(reader.getString());
                } else if ("wrappedDataEncryptionKey".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource
                        .withWrappedDataEncryptionKey(reader.getBinary());
                } else if ("keyWrapMetadata".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource
                        .withKeyWrapMetadata(KeyWrapMetadata.fromJson(reader));
                } else if ("_rid".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientEncryptionKeyGetPropertiesResource;
        });
    }
}
