// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Certificate model.
 */
@Fluent
public final class Certificate implements JsonSerializable<Certificate> {
    /*
     * PEM formatted public key.
     */
    private String pem;

    /**
     * Creates an instance of Certificate class.
     */
    public Certificate() {
    }

    /**
     * Get the pem property: PEM formatted public key.
     * 
     * @return the pem value.
     */
    public String pem() {
        return this.pem;
    }

    /**
     * Set the pem property: PEM formatted public key.
     * 
     * @param pem the pem value to set.
     * @return the Certificate object itself.
     */
    public Certificate withPem(String pem) {
        this.pem = pem;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("pem", this.pem);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Certificate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Certificate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Certificate.
     */
    public static Certificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Certificate deserializedCertificate = new Certificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("pem".equals(fieldName)) {
                    deserializedCertificate.pem = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificate;
        });
    }
}
