// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.CassandraKeyspaceGetResultsInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the Cassandra keyspaces and their properties.
 */
@Immutable
public final class CassandraKeyspaceListResult implements JsonSerializable<CassandraKeyspaceListResult> {
    /*
     * List of Cassandra keyspaces and their properties.
     */
    private List<CassandraKeyspaceGetResultsInner> value;

    /**
     * Creates an instance of CassandraKeyspaceListResult class.
     */
    public CassandraKeyspaceListResult() {
    }

    /**
     * Get the value property: List of Cassandra keyspaces and their properties.
     * 
     * @return the value value.
     */
    public List<CassandraKeyspaceGetResultsInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraKeyspaceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraKeyspaceListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CassandraKeyspaceListResult.
     */
    public static CassandraKeyspaceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraKeyspaceListResult deserializedCassandraKeyspaceListResult = new CassandraKeyspaceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CassandraKeyspaceGetResultsInner> value
                        = reader.readArray(reader1 -> CassandraKeyspaceGetResultsInner.fromJson(reader1));
                    deserializedCassandraKeyspaceListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraKeyspaceListResult;
        });
    }
}
