// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB capability object.
 */
@Fluent
public final class Capability implements JsonSerializable<Capability> {
    /*
     * Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include
     * "EnableTable" and "EnableGremlin".
     */
    private String name;

    /**
     * Creates an instance of Capability class.
     */
    public Capability() {
    }

    /**
     * Get the name property: Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values
     * also include "EnableTable" and "EnableGremlin".
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values
     * also include "EnableTable" and "EnableGremlin".
     * 
     * @param name the name value to set.
     * @return the Capability object itself.
     */
    public Capability withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Capability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Capability if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Capability.
     */
    public static Capability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Capability deserializedCapability = new Capability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCapability.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapability;
        });
    }
}
