// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The object representing the state of the migration between the backup policies.
 */
@Fluent
public final class BackupPolicyMigrationState implements JsonSerializable<BackupPolicyMigrationState> {
    /*
     * Describes the status of migration between backup policy types.
     */
    private BackupPolicyMigrationStatus status;

    /*
     * Describes the target backup policy type of the backup policy migration.
     */
    private BackupPolicyType targetType;

    /*
     * Time at which the backup policy migration started (ISO-8601 format).
     */
    private OffsetDateTime startTime;

    /**
     * Creates an instance of BackupPolicyMigrationState class.
     */
    public BackupPolicyMigrationState() {
    }

    /**
     * Get the status property: Describes the status of migration between backup policy types.
     * 
     * @return the status value.
     */
    public BackupPolicyMigrationStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Describes the status of migration between backup policy types.
     * 
     * @param status the status value to set.
     * @return the BackupPolicyMigrationState object itself.
     */
    public BackupPolicyMigrationState withStatus(BackupPolicyMigrationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the targetType property: Describes the target backup policy type of the backup policy migration.
     * 
     * @return the targetType value.
     */
    public BackupPolicyType targetType() {
        return this.targetType;
    }

    /**
     * Set the targetType property: Describes the target backup policy type of the backup policy migration.
     * 
     * @param targetType the targetType value to set.
     * @return the BackupPolicyMigrationState object itself.
     */
    public BackupPolicyMigrationState withTargetType(BackupPolicyType targetType) {
        this.targetType = targetType;
        return this;
    }

    /**
     * Get the startTime property: Time at which the backup policy migration started (ISO-8601 format).
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Time at which the backup policy migration started (ISO-8601 format).
     * 
     * @param startTime the startTime value to set.
     * @return the BackupPolicyMigrationState object itself.
     */
    public BackupPolicyMigrationState withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("targetType", this.targetType == null ? null : this.targetType.toString());
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupPolicyMigrationState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupPolicyMigrationState if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackupPolicyMigrationState.
     */
    public static BackupPolicyMigrationState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupPolicyMigrationState deserializedBackupPolicyMigrationState = new BackupPolicyMigrationState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedBackupPolicyMigrationState.status
                        = BackupPolicyMigrationStatus.fromString(reader.getString());
                } else if ("targetType".equals(fieldName)) {
                    deserializedBackupPolicyMigrationState.targetType = BackupPolicyType.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedBackupPolicyMigrationState.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupPolicyMigrationState;
        });
    }
}
