// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB resource auto-upgrade policy.
 */
@Fluent
public final class AutoUpgradePolicyResource implements JsonSerializable<AutoUpgradePolicyResource> {
    /*
     * Represents throughput policy which service must adhere to for auto-upgrade
     */
    private ThroughputPolicyResource throughputPolicy;

    /**
     * Creates an instance of AutoUpgradePolicyResource class.
     */
    public AutoUpgradePolicyResource() {
    }

    /**
     * Get the throughputPolicy property: Represents throughput policy which service must adhere to for auto-upgrade.
     * 
     * @return the throughputPolicy value.
     */
    public ThroughputPolicyResource throughputPolicy() {
        return this.throughputPolicy;
    }

    /**
     * Set the throughputPolicy property: Represents throughput policy which service must adhere to for auto-upgrade.
     * 
     * @param throughputPolicy the throughputPolicy value to set.
     * @return the AutoUpgradePolicyResource object itself.
     */
    public AutoUpgradePolicyResource withThroughputPolicy(ThroughputPolicyResource throughputPolicy) {
        this.throughputPolicy = throughputPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (throughputPolicy() != null) {
            throughputPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("throughputPolicy", this.throughputPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoUpgradePolicyResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoUpgradePolicyResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutoUpgradePolicyResource.
     */
    public static AutoUpgradePolicyResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoUpgradePolicyResource deserializedAutoUpgradePolicyResource = new AutoUpgradePolicyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("throughputPolicy".equals(fieldName)) {
                    deserializedAutoUpgradePolicyResource.throughputPolicy = ThroughputPolicyResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoUpgradePolicyResource;
        });
    }
}
