// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should
 * not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is
 * 'Cassandra'.
 */
public final class AuthenticationMethod extends ExpandableStringEnum<AuthenticationMethod> {
    /**
     * Static value None for AuthenticationMethod.
     */
    public static final AuthenticationMethod NONE = fromString("None");

    /**
     * Static value Cassandra for AuthenticationMethod.
     */
    public static final AuthenticationMethod CASSANDRA = fromString("Cassandra");

    /**
     * Static value Ldap for AuthenticationMethod.
     */
    public static final AuthenticationMethod LDAP = fromString("Ldap");

    /**
     * Creates a new instance of AuthenticationMethod value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AuthenticationMethod() {
    }

    /**
     * Creates or finds a AuthenticationMethod from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AuthenticationMethod.
     */
    public static AuthenticationMethod fromString(String name) {
        return fromString(name, AuthenticationMethod.class);
    }

    /**
     * Gets known AuthenticationMethod values.
     * 
     * @return known AuthenticationMethod values.
     */
    public static Collection<AuthenticationMethod> values() {
        return values(AuthenticationMethod.class);
    }
}
