// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionGetPropertiesResource;
import java.io.IOException;

/**
 * The properties of an Azure Cosmos DB userDefinedFunction.
 */
@Fluent
public final class SqlUserDefinedFunctionGetProperties
    implements JsonSerializable<SqlUserDefinedFunctionGetProperties> {
    /*
     * The resource property.
     */
    private SqlUserDefinedFunctionGetPropertiesResource resource;

    /**
     * Creates an instance of SqlUserDefinedFunctionGetProperties class.
     */
    public SqlUserDefinedFunctionGetProperties() {
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public SqlUserDefinedFunctionGetPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the SqlUserDefinedFunctionGetProperties object itself.
     */
    public SqlUserDefinedFunctionGetProperties withResource(SqlUserDefinedFunctionGetPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", this.resource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlUserDefinedFunctionGetProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlUserDefinedFunctionGetProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SqlUserDefinedFunctionGetProperties.
     */
    public static SqlUserDefinedFunctionGetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlUserDefinedFunctionGetProperties deserializedSqlUserDefinedFunctionGetProperties
                = new SqlUserDefinedFunctionGetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resource".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetProperties.resource
                        = SqlUserDefinedFunctionGetPropertiesResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlUserDefinedFunctionGetProperties;
        });
    }
}
