// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specific Databases to restore.
 */
@Immutable
public final class RestorableTableResourcesGetResultInner
    implements JsonSerializable<RestorableTableResourcesGetResultInner> {
    /*
     * The unique resource identifier of the ARM resource.
     */
    private String id;

    /*
     * The name of the Table.
     */
    private String name;

    /*
     * The type of Azure resource.
     */
    private String type;

    /**
     * Creates an instance of RestorableTableResourcesGetResultInner class.
     */
    public RestorableTableResourcesGetResultInner() {
    }

    /**
     * Get the id property: The unique resource identifier of the ARM resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the Table.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableTableResourcesGetResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableTableResourcesGetResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableTableResourcesGetResultInner.
     */
    public static RestorableTableResourcesGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableTableResourcesGetResultInner deserializedRestorableTableResourcesGetResultInner
                = new RestorableTableResourcesGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRestorableTableResourcesGetResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRestorableTableResourcesGetResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRestorableTableResourcesGetResultInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableTableResourcesGetResultInner;
        });
    }
}
