// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.DataCenterResourceProperties;
import java.io.IOException;

/**
 * A managed Cassandra data center.
 */
@Fluent
public final class DataCenterResourceInner extends ArmProxyResource {
    /*
     * Properties of a managed Cassandra data center.
     */
    private DataCenterResourceProperties properties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DataCenterResourceInner class.
     */
    public DataCenterResourceInner() {
    }

    /**
     * Get the properties property: Properties of a managed Cassandra data center.
     * 
     * @return the properties value.
     */
    public DataCenterResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of a managed Cassandra data center.
     * 
     * @param properties the properties value to set.
     * @return the DataCenterResourceInner object itself.
     */
    public DataCenterResourceInner withProperties(DataCenterResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataCenterResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataCenterResourceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataCenterResourceInner.
     */
    public static DataCenterResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCenterResourceInner deserializedDataCenterResourceInner = new DataCenterResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDataCenterResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDataCenterResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDataCenterResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDataCenterResourceInner.properties = DataCenterResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataCenterResourceInner;
        });
    }
}
