/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.SqlContainerGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.SqlContainerGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.SqlContainerGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class SqlContainerGetResultsInner
extends ArmResourceProperties {
    private SqlContainerGetProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SqlContainerGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SqlContainerGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SqlContainerGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public SqlContainerGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public SqlContainerGetResultsInner withResource(SqlContainerGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlContainerGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public SqlContainerGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public SqlContainerGetResultsInner withOptions(SqlContainerGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlContainerGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SqlContainerGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (SqlContainerGetResultsInner)((Object)jsonReader.readObject(reader -> {
            SqlContainerGetResultsInner deserializedSqlContainerGetResultsInner = new SqlContainerGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlContainerGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlContainerGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlContainerGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSqlContainerGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlContainerGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSqlContainerGetResultsInner.innerProperties = SqlContainerGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlContainerGetResultsInner;
        }));
    }
}

