// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB SQL userDefinedFunction resource object.
 */
@Fluent
public class SqlUserDefinedFunctionResource implements JsonSerializable<SqlUserDefinedFunctionResource> {
    /*
     * Name of the Cosmos DB SQL userDefinedFunction
     */
    private String id;

    /*
     * Body of the User Defined Function
     */
    private String body;

    /**
     * Creates an instance of SqlUserDefinedFunctionResource class.
     */
    public SqlUserDefinedFunctionResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB SQL userDefinedFunction.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB SQL userDefinedFunction.
     * 
     * @param id the id value to set.
     * @return the SqlUserDefinedFunctionResource object itself.
     */
    public SqlUserDefinedFunctionResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the body property: Body of the User Defined Function.
     * 
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body of the User Defined Function.
     * 
     * @param body the body value to set.
     * @return the SqlUserDefinedFunctionResource object itself.
     */
    public SqlUserDefinedFunctionResource withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property id in model SqlUserDefinedFunctionResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlUserDefinedFunctionResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("body", this.body);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlUserDefinedFunctionResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlUserDefinedFunctionResource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlUserDefinedFunctionResource.
     */
    public static SqlUserDefinedFunctionResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlUserDefinedFunctionResource deserializedSqlUserDefinedFunctionResource
                = new SqlUserDefinedFunctionResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionResource.id = reader.getString();
                } else if ("body".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionResource.body = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlUserDefinedFunctionResource;
        });
    }
}
