// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A metric name.
 */
@Immutable
public final class MetricName implements JsonSerializable<MetricName> {
    /*
     * The name of the metric.
     */
    private String value;

    /*
     * The friendly name of the metric.
     */
    private String localizedValue;

    /**
     * Creates an instance of MetricName class.
     */
    public MetricName() {
    }

    /**
     * Get the value property: The name of the metric.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the localizedValue property: The friendly name of the metric.
     * 
     * @return the localizedValue value.
     */
    public String localizedValue() {
        return this.localizedValue;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricName from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricName if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the MetricName.
     */
    public static MetricName fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricName deserializedMetricName = new MetricName();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedMetricName.value = reader.getString();
                } else if ("localizedValue".equals(fieldName)) {
                    deserializedMetricName.localizedValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricName;
        });
    }
}
