// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ContinuousBackupInformation;
import java.io.IOException;

/**
 * Backup information of a resource.
 */
@Immutable
public final class BackupInformationInner implements JsonSerializable<BackupInformationInner> {
    /*
     * Information about the status of continuous backups.
     */
    private ContinuousBackupInformation continuousBackupInformation;

    /**
     * Creates an instance of BackupInformationInner class.
     */
    public BackupInformationInner() {
    }

    /**
     * Get the continuousBackupInformation property: Information about the status of continuous backups.
     * 
     * @return the continuousBackupInformation value.
     */
    public ContinuousBackupInformation continuousBackupInformation() {
        return this.continuousBackupInformation;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (continuousBackupInformation() != null) {
            continuousBackupInformation().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupInformationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupInformationInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackupInformationInner.
     */
    public static BackupInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupInformationInner deserializedBackupInformationInner = new BackupInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("continuousBackupInformation".equals(fieldName)) {
                    deserializedBackupInformationInner.continuousBackupInformation
                        = ContinuousBackupInformation.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupInformationInner;
        });
    }
}
