// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SqlContainerGetPropertiesResource model.
 */
@Fluent
public final class SqlContainerGetPropertiesResource extends SqlContainerResource {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of SqlContainerGetPropertiesResource class.
     */
    public SqlContainerGetPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource
        withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        super.withClientEncryptionPolicy(clientEncryptionPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlContainerGetPropertiesResource withComputedProperties(List<ComputedProperty> computedProperties) {
        super.withComputedProperties(computedProperties);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property id in model SqlContainerGetPropertiesResource"));
        }
        if (indexingPolicy() != null) {
            indexingPolicy().validate();
        }
        if (partitionKey() != null) {
            partitionKey().validate();
        }
        if (uniqueKeyPolicy() != null) {
            uniqueKeyPolicy().validate();
        }
        if (conflictResolutionPolicy() != null) {
            conflictResolutionPolicy().validate();
        }
        if (clientEncryptionPolicy() != null) {
            clientEncryptionPolicy().validate();
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
        if (computedProperties() != null) {
            computedProperties().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlContainerGetPropertiesResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("indexingPolicy", indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", partitionKey());
        jsonWriter.writeNumberField("defaultTtl", defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", conflictResolutionPolicy());
        jsonWriter.writeJsonField("clientEncryptionPolicy", clientEncryptionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", restoreParameters());
        jsonWriter.writeStringField("createMode", createMode() == null ? null : createMode().toString());
        jsonWriter.writeArrayField("computedProperties", computedProperties(),
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlContainerGetPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlContainerGetPropertiesResource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlContainerGetPropertiesResource.
     */
    public static SqlContainerGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlContainerGetPropertiesResource deserializedSqlContainerGetPropertiesResource
                = new SqlContainerGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withId(reader.getString());
                } else if ("indexingPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withIndexingPolicy(IndexingPolicy.fromJson(reader));
                } else if ("partitionKey".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withPartitionKey(ContainerPartitionKey.fromJson(reader));
                } else if ("defaultTtl".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withDefaultTtl(reader.getNullable(JsonReader::getInt));
                } else if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                } else if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                } else if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withClientEncryptionPolicy(ClientEncryptionPolicy.fromJson(reader));
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withAnalyticalStorageTtl(reader.getNullable(JsonReader::getLong));
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                } else if ("createMode".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource
                        .withCreateMode(CreateMode.fromString(reader.getString()));
                } else if ("computedProperties".equals(fieldName)) {
                    List<ComputedProperty> computedProperties
                        = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    deserializedSqlContainerGetPropertiesResource.withComputedProperties(computedProperties);
                } else if ("_rid".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedSqlContainerGetPropertiesResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlContainerGetPropertiesResource;
        });
    }
}
