// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableDatabaseAccountGetResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the restorable database accounts and their properties.
 */
@Immutable
public final class RestorableDatabaseAccountsListResult
    implements JsonSerializable<RestorableDatabaseAccountsListResult> {
    /*
     * List of restorable database accounts and their properties.
     */
    private List<RestorableDatabaseAccountGetResultInner> value;

    /**
     * Creates an instance of RestorableDatabaseAccountsListResult class.
     */
    public RestorableDatabaseAccountsListResult() {
    }

    /**
     * Get the value property: List of restorable database accounts and their properties.
     * 
     * @return the value value.
     */
    public List<RestorableDatabaseAccountGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableDatabaseAccountsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableDatabaseAccountsListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableDatabaseAccountsListResult.
     */
    public static RestorableDatabaseAccountsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableDatabaseAccountsListResult deserializedRestorableDatabaseAccountsListResult
                = new RestorableDatabaseAccountsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RestorableDatabaseAccountGetResultInner> value
                        = reader.readArray(reader1 -> RestorableDatabaseAccountGetResultInner.fromJson(reader1));
                    deserializedRestorableDatabaseAccountsListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableDatabaseAccountsListResult;
        });
    }
}
