// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB MongoDB collection index options.
 */
@Fluent
public final class MongoIndexOptions implements JsonSerializable<MongoIndexOptions> {
    /*
     * Expire after seconds
     */
    private Integer expireAfterSeconds;

    /*
     * Is unique or not
     */
    private Boolean unique;

    /**
     * Creates an instance of MongoIndexOptions class.
     */
    public MongoIndexOptions() {
    }

    /**
     * Get the expireAfterSeconds property: Expire after seconds.
     * 
     * @return the expireAfterSeconds value.
     */
    public Integer expireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    /**
     * Set the expireAfterSeconds property: Expire after seconds.
     * 
     * @param expireAfterSeconds the expireAfterSeconds value to set.
     * @return the MongoIndexOptions object itself.
     */
    public MongoIndexOptions withExpireAfterSeconds(Integer expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    /**
     * Get the unique property: Is unique or not.
     * 
     * @return the unique value.
     */
    public Boolean unique() {
        return this.unique;
    }

    /**
     * Set the unique property: Is unique or not.
     * 
     * @param unique the unique value to set.
     * @return the MongoIndexOptions object itself.
     */
    public MongoIndexOptions withUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("expireAfterSeconds", this.expireAfterSeconds);
        jsonWriter.writeBooleanField("unique", this.unique);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoIndexOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoIndexOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MongoIndexOptions.
     */
    public static MongoIndexOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoIndexOptions deserializedMongoIndexOptions = new MongoIndexOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expireAfterSeconds".equals(fieldName)) {
                    deserializedMongoIndexOptions.expireAfterSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("unique".equals(fieldName)) {
                    deserializedMongoIndexOptions.unique = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMongoIndexOptions;
        });
    }
}
