// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The object that represents all properties related to capacity enforcement on an account.
 */
@Fluent
public final class Capacity implements JsonSerializable<Capacity> {
    /*
     * The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max
     * throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits
     * on provisioning of throughput.
     */
    private Integer totalThroughputLimit;

    /**
     * Creates an instance of Capacity class.
     */
    public Capacity() {
    }

    /**
     * Get the totalThroughputLimit property: The total throughput limit imposed on the account. A totalThroughputLimit
     * of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A
     * totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
     * 
     * @return the totalThroughputLimit value.
     */
    public Integer totalThroughputLimit() {
        return this.totalThroughputLimit;
    }

    /**
     * Set the totalThroughputLimit property: The total throughput limit imposed on the account. A totalThroughputLimit
     * of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A
     * totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
     * 
     * @param totalThroughputLimit the totalThroughputLimit value to set.
     * @return the Capacity object itself.
     */
    public Capacity withTotalThroughputLimit(Integer totalThroughputLimit) {
        this.totalThroughputLimit = totalThroughputLimit;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("totalThroughputLimit", this.totalThroughputLimit);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Capacity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Capacity if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Capacity.
     */
    public static Capacity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Capacity deserializedCapacity = new Capacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("totalThroughputLimit".equals(fieldName)) {
                    deserializedCapacity.totalThroughputLimit = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapacity;
        });
    }
}
