// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Analytical storage specific properties.
 */
@Fluent
public final class AnalyticalStorageConfiguration implements JsonSerializable<AnalyticalStorageConfiguration> {
    /*
     * Describes the types of schema for analytical storage.
     */
    private AnalyticalStorageSchemaType schemaType;

    /**
     * Creates an instance of AnalyticalStorageConfiguration class.
     */
    public AnalyticalStorageConfiguration() {
    }

    /**
     * Get the schemaType property: Describes the types of schema for analytical storage.
     * 
     * @return the schemaType value.
     */
    public AnalyticalStorageSchemaType schemaType() {
        return this.schemaType;
    }

    /**
     * Set the schemaType property: Describes the types of schema for analytical storage.
     * 
     * @param schemaType the schemaType value to set.
     * @return the AnalyticalStorageConfiguration object itself.
     */
    public AnalyticalStorageConfiguration withSchemaType(AnalyticalStorageSchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schemaType", this.schemaType == null ? null : this.schemaType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyticalStorageConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyticalStorageConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AnalyticalStorageConfiguration.
     */
    public static AnalyticalStorageConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnalyticalStorageConfiguration deserializedAnalyticalStorageConfiguration
                = new AnalyticalStorageConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schemaType".equals(fieldName)) {
                    deserializedAnalyticalStorageConfiguration.schemaType
                        = AnalyticalStorageSchemaType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAnalyticalStorageConfiguration;
        });
    }
}
