// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specific Databases to restore.
 */
@Fluent
public final class RestorableSqlResourcesGetResultInner
    implements JsonSerializable<RestorableSqlResourcesGetResultInner> {
    /*
     * The unique resource identifier of the ARM resource.
     */
    private String id;

    /*
     * The name of the ARM resource.
     */
    private String name;

    /*
     * The type of Azure resource.
     */
    private String type;

    /*
     * The name of the database available for restore.
     */
    private String databaseName;

    /*
     * The names of the collections available for restore.
     */
    private List<String> collectionNames;

    /**
     * Creates an instance of RestorableSqlResourcesGetResultInner class.
     */
    public RestorableSqlResourcesGetResultInner() {
    }

    /**
     * Get the id property: The unique resource identifier of the ARM resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the ARM resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the databaseName property: The name of the database available for restore.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: The name of the database available for restore.
     * 
     * @param databaseName the databaseName value to set.
     * @return the RestorableSqlResourcesGetResultInner object itself.
     */
    public RestorableSqlResourcesGetResultInner withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the collectionNames property: The names of the collections available for restore.
     * 
     * @return the collectionNames value.
     */
    public List<String> collectionNames() {
        return this.collectionNames;
    }

    /**
     * Set the collectionNames property: The names of the collections available for restore.
     * 
     * @param collectionNames the collectionNames value to set.
     * @return the RestorableSqlResourcesGetResultInner object itself.
     */
    public RestorableSqlResourcesGetResultInner withCollectionNames(List<String> collectionNames) {
        this.collectionNames = collectionNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeArrayField("collectionNames", this.collectionNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableSqlResourcesGetResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableSqlResourcesGetResultInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableSqlResourcesGetResultInner.
     */
    public static RestorableSqlResourcesGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlResourcesGetResultInner deserializedRestorableSqlResourcesGetResultInner
                = new RestorableSqlResourcesGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRestorableSqlResourcesGetResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRestorableSqlResourcesGetResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRestorableSqlResourcesGetResultInner.type = reader.getString();
                } else if ("databaseName".equals(fieldName)) {
                    deserializedRestorableSqlResourcesGetResultInner.databaseName = reader.getString();
                } else if ("collectionNames".equals(fieldName)) {
                    List<String> collectionNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedRestorableSqlResourcesGetResultInner.collectionNames = collectionNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableSqlResourcesGetResultInner;
        });
    }
}
