/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.SqlUserDefinedFunctionCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionResource;
import java.io.IOException;
import java.util.Map;

public final class SqlUserDefinedFunctionCreateUpdateParameters
extends ArmResourceProperties {
    private SqlUserDefinedFunctionCreateUpdateProperties innerProperties = new SqlUserDefinedFunctionCreateUpdateProperties();
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(SqlUserDefinedFunctionCreateUpdateParameters.class);

    private SqlUserDefinedFunctionCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SqlUserDefinedFunctionCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SqlUserDefinedFunctionCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public SqlUserDefinedFunctionResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public SqlUserDefinedFunctionCreateUpdateParameters withResource(SqlUserDefinedFunctionResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlUserDefinedFunctionCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public SqlUserDefinedFunctionCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlUserDefinedFunctionCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SqlUserDefinedFunctionCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SqlUserDefinedFunctionCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SqlUserDefinedFunctionCreateUpdateParameters)((Object)jsonReader.readObject(reader -> {
            SqlUserDefinedFunctionCreateUpdateParameters deserializedSqlUserDefinedFunctionCreateUpdateParameters = new SqlUserDefinedFunctionCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionCreateUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionCreateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionCreateUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionCreateUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlUserDefinedFunctionCreateUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionCreateUpdateParameters.innerProperties = SqlUserDefinedFunctionCreateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlUserDefinedFunctionCreateUpdateParameters;
        }));
    }
}

