/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.SqlTriggerResource;
import com.azure.resourcemanager.cosmos.models.TriggerOperation;
import com.azure.resourcemanager.cosmos.models.TriggerType;
import java.io.IOException;

public final class SqlTriggerGetPropertiesResource
extends SqlTriggerResource {
    private String rid;
    private Float ts;
    private String etag;

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public SqlTriggerGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SqlTriggerGetPropertiesResource withBody(String body) {
        super.withBody(body);
        return this;
    }

    @Override
    public SqlTriggerGetPropertiesResource withTriggerType(TriggerType triggerType) {
        super.withTriggerType(triggerType);
        return this;
    }

    @Override
    public SqlTriggerGetPropertiesResource withTriggerOperation(TriggerOperation triggerOperation) {
        super.withTriggerOperation(triggerOperation);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("body", this.body());
        jsonWriter.writeStringField("triggerType", this.triggerType() == null ? null : this.triggerType().toString());
        jsonWriter.writeStringField("triggerOperation", this.triggerOperation() == null ? null : this.triggerOperation().toString());
        return jsonWriter.writeEndObject();
    }

    public static SqlTriggerGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlTriggerGetPropertiesResource)jsonReader.readObject(reader -> {
            SqlTriggerGetPropertiesResource deserializedSqlTriggerGetPropertiesResource = new SqlTriggerGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.withBody(reader.getString());
                    continue;
                }
                if ("triggerType".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.withTriggerType(TriggerType.fromString(reader.getString()));
                    continue;
                }
                if ("triggerOperation".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.withTriggerOperation(TriggerOperation.fromString(reader.getString()));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedSqlTriggerGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlTriggerGetPropertiesResource;
        });
    }
}

