/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseResource;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import java.io.IOException;

public final class MongoDBDatabaseGetPropertiesResource
extends MongoDBDatabaseResource {
    private String rid;
    private Float ts;
    private String etag;

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public MongoDBDatabaseGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public MongoDBDatabaseGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public MongoDBDatabaseGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDBDatabaseGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDBDatabaseGetPropertiesResource)jsonReader.readObject(reader -> {
            MongoDBDatabaseGetPropertiesResource deserializedMongoDBDatabaseGetPropertiesResource = new MongoDBDatabaseGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetPropertiesResource.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetPropertiesResource.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDBDatabaseGetPropertiesResource;
        });
    }
}

