/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ServiceResourceCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.azure.resourcemanager.cosmos.models.ServiceType;
import java.io.IOException;

public final class MaterializedViewsBuilderServiceResourceCreateUpdateParameters
extends ServiceResourceCreateUpdateProperties {
    private ServiceType serviceType = ServiceType.MATERIALIZED_VIEWS_BUILDER;

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Override
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    @Override
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", this.instanceSize() == null ? null : this.instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", (Number)this.instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        return jsonWriter.writeEndObject();
    }

    public static MaterializedViewsBuilderServiceResourceCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (MaterializedViewsBuilderServiceResourceCreateUpdateParameters)jsonReader.readObject(reader -> {
            MaterializedViewsBuilderServiceResourceCreateUpdateParameters deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters = new MaterializedViewsBuilderServiceResourceCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instanceSize".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters.withInstanceSize(ServiceSize.fromString(reader.getString()));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters.withInstanceCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("serviceType".equals(fieldName)) {
                    deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaterializedViewsBuilderServiceResourceCreateUpdateParameters;
        });
    }
}

