/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.SqlTriggerGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.SqlTriggerGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class SqlTriggerGetResultsInner
extends ArmResourceProperties {
    private SqlTriggerGetProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private SqlTriggerGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SqlTriggerGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SqlTriggerGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public SqlTriggerGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public SqlTriggerGetResultsInner withResource(SqlTriggerGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlTriggerGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SqlTriggerGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (SqlTriggerGetResultsInner)((Object)jsonReader.readObject(reader -> {
            SqlTriggerGetResultsInner deserializedSqlTriggerGetResultsInner = new SqlTriggerGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlTriggerGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlTriggerGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlTriggerGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSqlTriggerGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlTriggerGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSqlTriggerGetResultsInner.innerProperties = SqlTriggerGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlTriggerGetResultsInner;
        }));
    }
}

