/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MongoRoleDefinitionResource;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.MongoRoleDefinitionType;
import com.azure.resourcemanager.cosmos.models.Privilege;
import com.azure.resourcemanager.cosmos.models.Role;
import java.io.IOException;
import java.util.List;

public final class MongoRoleDefinitionGetResultsInner
extends ArmProxyResource {
    private MongoRoleDefinitionResource innerProperties;
    private String id;
    private String name;
    private String type;

    private MongoRoleDefinitionResource innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    public String roleName() {
        return this.innerProperties() == null ? null : this.innerProperties().roleName();
    }

    public MongoRoleDefinitionGetResultsInner withRoleName(String roleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withRoleName(roleName);
        return this;
    }

    public MongoRoleDefinitionType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public MongoRoleDefinitionGetResultsInner withTypePropertiesType(MongoRoleDefinitionType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    public MongoRoleDefinitionGetResultsInner withDatabaseName(String databaseName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withDatabaseName(databaseName);
        return this;
    }

    public List<Privilege> privileges() {
        return this.innerProperties() == null ? null : this.innerProperties().privileges();
    }

    public MongoRoleDefinitionGetResultsInner withPrivileges(List<Privilege> privileges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withPrivileges(privileges);
        return this;
    }

    public List<Role> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    public MongoRoleDefinitionGetResultsInner withRoles(List<Role> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MongoRoleDefinitionGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (MongoRoleDefinitionGetResultsInner)((Object)jsonReader.readObject(reader -> {
            MongoRoleDefinitionGetResultsInner deserializedMongoRoleDefinitionGetResultsInner = new MongoRoleDefinitionGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoRoleDefinitionGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoRoleDefinitionGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoRoleDefinitionGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMongoRoleDefinitionGetResultsInner.innerProperties = MongoRoleDefinitionResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoRoleDefinitionGetResultsInner;
        }));
    }
}

