/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBCollectionGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.MongoDBCollectionGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.MongoDBCollectionGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class MongoDBCollectionGetResultsInner
extends ArmResourceProperties {
    private MongoDBCollectionGetProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private MongoDBCollectionGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public MongoDBCollectionGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MongoDBCollectionGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public MongoDBCollectionGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public MongoDBCollectionGetResultsInner withResource(MongoDBCollectionGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBCollectionGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public MongoDBCollectionGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public MongoDBCollectionGetResultsInner withOptions(MongoDBCollectionGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBCollectionGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MongoDBCollectionGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDBCollectionGetResultsInner)((Object)jsonReader.readObject(reader -> {
            MongoDBCollectionGetResultsInner deserializedMongoDBCollectionGetResultsInner = new MongoDBCollectionGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoDBCollectionGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDBCollectionGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDBCollectionGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMongoDBCollectionGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBCollectionGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMongoDBCollectionGetResultsInner.innerProperties = MongoDBCollectionGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDBCollectionGetResultsInner;
        }));
    }
}

