// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SqlUserDefinedFunctionGetPropertiesResource model.
 */
@Fluent
public final class SqlUserDefinedFunctionGetPropertiesResource extends SqlUserDefinedFunctionResource {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of SqlUserDefinedFunctionGetPropertiesResource class.
     */
    public SqlUserDefinedFunctionGetPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlUserDefinedFunctionGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlUserDefinedFunctionGetPropertiesResource withBody(String body) {
        super.withBody(body);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("body", body());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlUserDefinedFunctionGetPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlUserDefinedFunctionGetPropertiesResource if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlUserDefinedFunctionGetPropertiesResource.
     */
    public static SqlUserDefinedFunctionGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlUserDefinedFunctionGetPropertiesResource deserializedSqlUserDefinedFunctionGetPropertiesResource
                = new SqlUserDefinedFunctionGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.withId(reader.getString());
                } else if ("body".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.withBody(reader.getString());
                } else if ("_rid".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.ts
                        = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlUserDefinedFunctionGetPropertiesResource;
        });
    }
}
