// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleAssignmentResource;
import java.io.IOException;

/**
 * Parameters to create and update an Azure Cosmos DB SQL Role Assignment.
 */
@Fluent
public final class SqlRoleAssignmentCreateUpdateParameters
    implements JsonSerializable<SqlRoleAssignmentCreateUpdateParameters> {
    /*
     * Properties to create and update an Azure Cosmos DB SQL Role Assignment.
     */
    private SqlRoleAssignmentResource innerProperties;

    /**
     * Creates an instance of SqlRoleAssignmentCreateUpdateParameters class.
     */
    public SqlRoleAssignmentCreateUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Properties to create and update an Azure Cosmos DB SQL Role Assignment.
     * 
     * @return the innerProperties value.
     */
    private SqlRoleAssignmentResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the roleDefinitionId property: The unique identifier for the associated Role Definition.
     * 
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The unique identifier for the associated Role Definition.
     * 
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the SqlRoleAssignmentCreateUpdateParameters object itself.
     */
    public SqlRoleAssignmentCreateUpdateParameters withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the scope property: The data plane resource path for which access is being granted through this Role
     * Assignment.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The data plane resource path for which access is being granted through this Role
     * Assignment.
     * 
     * @param scope the scope value to set.
     * @return the SqlRoleAssignmentCreateUpdateParameters object itself.
     */
    public SqlRoleAssignmentCreateUpdateParameters withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the principalId property: The unique identifier for the associated AAD principal in the AAD graph to which
     * access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant
     * associated with the subscription.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The unique identifier for the associated AAD principal in the AAD graph to which
     * access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant
     * associated with the subscription.
     * 
     * @param principalId the principalId value to set.
     * @return the SqlRoleAssignmentCreateUpdateParameters object itself.
     */
    public SqlRoleAssignmentCreateUpdateParameters withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlRoleAssignmentCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlRoleAssignmentCreateUpdateParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SqlRoleAssignmentCreateUpdateParameters.
     */
    public static SqlRoleAssignmentCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlRoleAssignmentCreateUpdateParameters deserializedSqlRoleAssignmentCreateUpdateParameters
                = new SqlRoleAssignmentCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedSqlRoleAssignmentCreateUpdateParameters.innerProperties
                        = SqlRoleAssignmentResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlRoleAssignmentCreateUpdateParameters;
        });
    }
}
