// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Properties for SqlDedicatedGatewayServiceResource.
 */
@Fluent
public final class SqlDedicatedGatewayServiceResourceProperties extends ServiceResourceProperties {
    /*
     * ServiceType for the service.
     */
    private ServiceType serviceType = ServiceType.SQL_DEDICATED_GATEWAY;

    /*
     * SqlDedicatedGateway endpoint for the service.
     */
    private String sqlDedicatedGatewayEndpoint;

    /*
     * DedicatedGatewayType for the service.
     */
    private DedicatedGatewayType dedicatedGatewayType;

    /*
     * An array that contains all of the locations for the service.
     */
    private List<SqlDedicatedGatewayRegionalServiceResource> locations;

    /*
     * Time of the last state change (ISO-8601 format).
     */
    private OffsetDateTime creationTime;

    /*
     * Describes the status of a service.
     */
    private ServiceStatus status;

    /**
     * Creates an instance of SqlDedicatedGatewayServiceResourceProperties class.
     */
    public SqlDedicatedGatewayServiceResourceProperties() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * Get the sqlDedicatedGatewayEndpoint property: SqlDedicatedGateway endpoint for the service.
     * 
     * @return the sqlDedicatedGatewayEndpoint value.
     */
    public String sqlDedicatedGatewayEndpoint() {
        return this.sqlDedicatedGatewayEndpoint;
    }

    /**
     * Set the sqlDedicatedGatewayEndpoint property: SqlDedicatedGateway endpoint for the service.
     * 
     * @param sqlDedicatedGatewayEndpoint the sqlDedicatedGatewayEndpoint value to set.
     * @return the SqlDedicatedGatewayServiceResourceProperties object itself.
     */
    public SqlDedicatedGatewayServiceResourceProperties
        withSqlDedicatedGatewayEndpoint(String sqlDedicatedGatewayEndpoint) {
        this.sqlDedicatedGatewayEndpoint = sqlDedicatedGatewayEndpoint;
        return this;
    }

    /**
     * Get the dedicatedGatewayType property: DedicatedGatewayType for the service.
     * 
     * @return the dedicatedGatewayType value.
     */
    public DedicatedGatewayType dedicatedGatewayType() {
        return this.dedicatedGatewayType;
    }

    /**
     * Set the dedicatedGatewayType property: DedicatedGatewayType for the service.
     * 
     * @param dedicatedGatewayType the dedicatedGatewayType value to set.
     * @return the SqlDedicatedGatewayServiceResourceProperties object itself.
     */
    public SqlDedicatedGatewayServiceResourceProperties
        withDedicatedGatewayType(DedicatedGatewayType dedicatedGatewayType) {
        this.dedicatedGatewayType = dedicatedGatewayType;
        return this;
    }

    /**
     * Get the locations property: An array that contains all of the locations for the service.
     * 
     * @return the locations value.
     */
    public List<SqlDedicatedGatewayRegionalServiceResource> locations() {
        return this.locations;
    }

    /**
     * Get the creationTime property: Time of the last state change (ISO-8601 format).
     * 
     * @return the creationTime value.
     */
    @Override
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get the status property: Describes the status of a service.
     * 
     * @return the status value.
     */
    @Override
    public ServiceStatus status() {
        return this.status;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDedicatedGatewayServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDedicatedGatewayServiceResourceProperties withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (locations() != null) {
            locations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", instanceSize() == null ? null : instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("sqlDedicatedGatewayEndpoint", this.sqlDedicatedGatewayEndpoint);
        jsonWriter.writeStringField("dedicatedGatewayType",
            this.dedicatedGatewayType == null ? null : this.dedicatedGatewayType.toString());
        if (additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlDedicatedGatewayServiceResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlDedicatedGatewayServiceResourceProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SqlDedicatedGatewayServiceResourceProperties.
     */
    public static SqlDedicatedGatewayServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlDedicatedGatewayServiceResourceProperties deserializedSqlDedicatedGatewayServiceResourceProperties
                = new SqlDedicatedGatewayServiceResourceProperties();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("creationTime".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("instanceSize".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties
                        .withInstanceSize(ServiceSize.fromString(reader.getString()));
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties
                        .withInstanceCount(reader.getNullable(JsonReader::getInt));
                } else if ("status".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.status
                        = ServiceStatus.fromString(reader.getString());
                } else if ("serviceType".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.serviceType
                        = ServiceType.fromString(reader.getString());
                } else if ("sqlDedicatedGatewayEndpoint".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.sqlDedicatedGatewayEndpoint
                        = reader.getString();
                } else if ("dedicatedGatewayType".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.dedicatedGatewayType
                        = DedicatedGatewayType.fromString(reader.getString());
                } else if ("locations".equals(fieldName)) {
                    List<SqlDedicatedGatewayRegionalServiceResource> locations
                        = reader.readArray(reader1 -> SqlDedicatedGatewayRegionalServiceResource.fromJson(reader1));
                    deserializedSqlDedicatedGatewayServiceResourceProperties.locations = locations;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedSqlDedicatedGatewayServiceResourceProperties.withAdditionalProperties(additionalProperties);

            return deserializedSqlDedicatedGatewayServiceResourceProperties;
        });
    }
}
