// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Parameters to indicate the information about the restore.
 */
@Fluent
public class RestoreParametersBase implements JsonSerializable<RestoreParametersBase> {
    /*
     * The id of the restorable database account from which the restore has to be initiated. For example:
     * /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{
     * restorableDatabaseAccountName}
     */
    private String restoreSource;

    /*
     * Time to which the account has to be restored (ISO-8601 format).
     */
    private OffsetDateTime restoreTimestampInUtc;

    /**
     * Creates an instance of RestoreParametersBase class.
     */
    public RestoreParametersBase() {
    }

    /**
     * Get the restoreSource property: The id of the restorable database account from which the restore has to be
     * initiated. For example:
     * /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.
     * 
     * @return the restoreSource value.
     */
    public String restoreSource() {
        return this.restoreSource;
    }

    /**
     * Set the restoreSource property: The id of the restorable database account from which the restore has to be
     * initiated. For example:
     * /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.
     * 
     * @param restoreSource the restoreSource value to set.
     * @return the RestoreParametersBase object itself.
     */
    public RestoreParametersBase withRestoreSource(String restoreSource) {
        this.restoreSource = restoreSource;
        return this;
    }

    /**
     * Get the restoreTimestampInUtc property: Time to which the account has to be restored (ISO-8601 format).
     * 
     * @return the restoreTimestampInUtc value.
     */
    public OffsetDateTime restoreTimestampInUtc() {
        return this.restoreTimestampInUtc;
    }

    /**
     * Set the restoreTimestampInUtc property: Time to which the account has to be restored (ISO-8601 format).
     * 
     * @param restoreTimestampInUtc the restoreTimestampInUtc value to set.
     * @return the RestoreParametersBase object itself.
     */
    public RestoreParametersBase withRestoreTimestampInUtc(OffsetDateTime restoreTimestampInUtc) {
        this.restoreTimestampInUtc = restoreTimestampInUtc;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("restoreSource", this.restoreSource);
        jsonWriter.writeStringField("restoreTimestampInUtc",
            this.restoreTimestampInUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restoreTimestampInUtc));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestoreParametersBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestoreParametersBase if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestoreParametersBase.
     */
    public static RestoreParametersBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestoreParametersBase deserializedRestoreParametersBase = new RestoreParametersBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("restoreSource".equals(fieldName)) {
                    deserializedRestoreParametersBase.restoreSource = reader.getString();
                } else if ("restoreTimestampInUtc".equals(fieldName)) {
                    deserializedRestoreParametersBase.restoreTimestampInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestoreParametersBase;
        });
    }
}
