// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB SQL database resource object.
 */
@Fluent
public final class RestorableSqlDatabasePropertiesResourceDatabase extends SqlDatabaseResource {
    /*
     * A system generated property that specified the addressable path of the collections resource.
     */
    private String colls;

    /*
     * A system generated property that specifies the addressable path of the users resource.
     */
    private String users;

    /*
     * A system generated property that specifies the addressable path of the database resource.
     */
    private String self;

    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of RestorableSqlDatabasePropertiesResourceDatabase class.
     */
    public RestorableSqlDatabasePropertiesResourceDatabase() {
    }

    /**
     * Get the colls property: A system generated property that specified the addressable path of the collections
     * resource.
     * 
     * @return the colls value.
     */
    public String colls() {
        return this.colls;
    }

    /**
     * Get the users property: A system generated property that specifies the addressable path of the users resource.
     * 
     * @return the users value.
     */
    public String users() {
        return this.users;
    }

    /**
     * Get the self property: A system generated property that specifies the addressable path of the database resource.
     * 
     * @return the self value.
     */
    public String self() {
        return this.self;
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlDatabasePropertiesResourceDatabase withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlDatabasePropertiesResourceDatabase
        withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlDatabasePropertiesResourceDatabase withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("restoreParameters", restoreParameters());
        jsonWriter.writeStringField("createMode", createMode() == null ? null : createMode().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableSqlDatabasePropertiesResourceDatabase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableSqlDatabasePropertiesResourceDatabase if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RestorableSqlDatabasePropertiesResourceDatabase.
     */
    public static RestorableSqlDatabasePropertiesResourceDatabase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlDatabasePropertiesResourceDatabase deserializedRestorableSqlDatabasePropertiesResourceDatabase
                = new RestorableSqlDatabasePropertiesResourceDatabase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.withId(reader.getString());
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase
                        .withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                } else if ("createMode".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase
                        .withCreateMode(CreateMode.fromString(reader.getString()));
                } else if ("_colls".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.colls = reader.getString();
                } else if ("_users".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.users = reader.getString();
                } else if ("_self".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.self = reader.getString();
                } else if ("_rid".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.ts
                        = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedRestorableSqlDatabasePropertiesResourceDatabase.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableSqlDatabasePropertiesResourceDatabase;
        });
    }
}
