// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Represents percentile metrics values.
 */
@Immutable
public final class PercentileMetricValue extends MetricValue {
    /*
     * The 10th percentile value for the metric.
     */
    private Double p10;

    /*
     * The 25th percentile value for the metric.
     */
    private Double p25;

    /*
     * The 50th percentile value for the metric.
     */
    private Double p50;

    /*
     * The 75th percentile value for the metric.
     */
    private Double p75;

    /*
     * The 90th percentile value for the metric.
     */
    private Double p90;

    /*
     * The 95th percentile value for the metric.
     */
    private Double p95;

    /*
     * The 99th percentile value for the metric.
     */
    private Double p99;

    /*
     * The number of values for the metric.
     */
    private Integer count;

    /*
     * The average value of the metric.
     */
    private Double average;

    /*
     * The max value of the metric.
     */
    private Double maximum;

    /*
     * The min value of the metric.
     */
    private Double minimum;

    /*
     * The metric timestamp (ISO-8601 format).
     */
    private OffsetDateTime timestamp;

    /*
     * The total value of the metric.
     */
    private Double total;

    /**
     * Creates an instance of PercentileMetricValue class.
     */
    public PercentileMetricValue() {
    }

    /**
     * Get the p10 property: The 10th percentile value for the metric.
     * 
     * @return the p10 value.
     */
    public Double p10() {
        return this.p10;
    }

    /**
     * Get the p25 property: The 25th percentile value for the metric.
     * 
     * @return the p25 value.
     */
    public Double p25() {
        return this.p25;
    }

    /**
     * Get the p50 property: The 50th percentile value for the metric.
     * 
     * @return the p50 value.
     */
    public Double p50() {
        return this.p50;
    }

    /**
     * Get the p75 property: The 75th percentile value for the metric.
     * 
     * @return the p75 value.
     */
    public Double p75() {
        return this.p75;
    }

    /**
     * Get the p90 property: The 90th percentile value for the metric.
     * 
     * @return the p90 value.
     */
    public Double p90() {
        return this.p90;
    }

    /**
     * Get the p95 property: The 95th percentile value for the metric.
     * 
     * @return the p95 value.
     */
    public Double p95() {
        return this.p95;
    }

    /**
     * Get the p99 property: The 99th percentile value for the metric.
     * 
     * @return the p99 value.
     */
    public Double p99() {
        return this.p99;
    }

    /**
     * Get the count property: The number of values for the metric.
     * 
     * @return the count value.
     */
    @Override
    public Integer count() {
        return this.count;
    }

    /**
     * Get the average property: The average value of the metric.
     * 
     * @return the average value.
     */
    @Override
    public Double average() {
        return this.average;
    }

    /**
     * Get the maximum property: The max value of the metric.
     * 
     * @return the maximum value.
     */
    @Override
    public Double maximum() {
        return this.maximum;
    }

    /**
     * Get the minimum property: The min value of the metric.
     * 
     * @return the minimum value.
     */
    @Override
    public Double minimum() {
        return this.minimum;
    }

    /**
     * Get the timestamp property: The metric timestamp (ISO-8601 format).
     * 
     * @return the timestamp value.
     */
    @Override
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the total property: The total value of the metric.
     * 
     * @return the total value.
     */
    @Override
    public Double total() {
        return this.total;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PercentileMetricValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PercentileMetricValue if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PercentileMetricValue.
     */
    public static PercentileMetricValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PercentileMetricValue deserializedPercentileMetricValue = new PercentileMetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("_count".equals(fieldName)) {
                    deserializedPercentileMetricValue.count = reader.getNullable(JsonReader::getInt);
                } else if ("average".equals(fieldName)) {
                    deserializedPercentileMetricValue.average = reader.getNullable(JsonReader::getDouble);
                } else if ("maximum".equals(fieldName)) {
                    deserializedPercentileMetricValue.maximum = reader.getNullable(JsonReader::getDouble);
                } else if ("minimum".equals(fieldName)) {
                    deserializedPercentileMetricValue.minimum = reader.getNullable(JsonReader::getDouble);
                } else if ("timestamp".equals(fieldName)) {
                    deserializedPercentileMetricValue.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("total".equals(fieldName)) {
                    deserializedPercentileMetricValue.total = reader.getNullable(JsonReader::getDouble);
                } else if ("P10".equals(fieldName)) {
                    deserializedPercentileMetricValue.p10 = reader.getNullable(JsonReader::getDouble);
                } else if ("P25".equals(fieldName)) {
                    deserializedPercentileMetricValue.p25 = reader.getNullable(JsonReader::getDouble);
                } else if ("P50".equals(fieldName)) {
                    deserializedPercentileMetricValue.p50 = reader.getNullable(JsonReader::getDouble);
                } else if ("P75".equals(fieldName)) {
                    deserializedPercentileMetricValue.p75 = reader.getNullable(JsonReader::getDouble);
                } else if ("P90".equals(fieldName)) {
                    deserializedPercentileMetricValue.p90 = reader.getNullable(JsonReader::getDouble);
                } else if ("P95".equals(fieldName)) {
                    deserializedPercentileMetricValue.p95 = reader.getNullable(JsonReader::getDouble);
                } else if ("P99".equals(fieldName)) {
                    deserializedPercentileMetricValue.p99 = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPercentileMetricValue;
        });
    }
}
