// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The GremlinDatabaseGetPropertiesOptions model.
 */
@Fluent
public final class GremlinDatabaseGetPropertiesOptions extends OptionsResource {
    /**
     * Creates an instance of GremlinDatabaseGetPropertiesOptions class.
     */
    public GremlinDatabaseGetPropertiesOptions() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinDatabaseGetPropertiesOptions withThroughput(Integer throughput) {
        super.withThroughput(throughput);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinDatabaseGetPropertiesOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        super.withAutoscaleSettings(autoscaleSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", throughput());
        jsonWriter.writeJsonField("autoscaleSettings", autoscaleSettings());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GremlinDatabaseGetPropertiesOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GremlinDatabaseGetPropertiesOptions if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GremlinDatabaseGetPropertiesOptions.
     */
    public static GremlinDatabaseGetPropertiesOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GremlinDatabaseGetPropertiesOptions deserializedGremlinDatabaseGetPropertiesOptions
                = new GremlinDatabaseGetPropertiesOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("throughput".equals(fieldName)) {
                    deserializedGremlinDatabaseGetPropertiesOptions
                        .withThroughput(reader.getNullable(JsonReader::getInt));
                } else if ("autoscaleSettings".equals(fieldName)) {
                    deserializedGremlinDatabaseGetPropertiesOptions
                        .withAutoscaleSettings(AutoscaleSettings.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGremlinDatabaseGetPropertiesOptions;
        });
    }
}
