// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Properties for GraphAPIComputeServiceResource.
 */
@Fluent
public final class GraphApiComputeServiceResourceProperties extends ServiceResourceProperties {
    /*
     * ServiceType for the service.
     */
    private ServiceType serviceType = ServiceType.GRAPH_APICOMPUTE;

    /*
     * GraphAPICompute endpoint for the service.
     */
    private String graphApiComputeEndpoint;

    /*
     * An array that contains all of the locations for the service.
     */
    private List<GraphApiComputeRegionalServiceResource> locations;

    /*
     * Time of the last state change (ISO-8601 format).
     */
    private OffsetDateTime creationTime;

    /*
     * Describes the status of a service.
     */
    private ServiceStatus status;

    /**
     * Creates an instance of GraphApiComputeServiceResourceProperties class.
     */
    public GraphApiComputeServiceResourceProperties() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * Get the graphApiComputeEndpoint property: GraphAPICompute endpoint for the service.
     * 
     * @return the graphApiComputeEndpoint value.
     */
    public String graphApiComputeEndpoint() {
        return this.graphApiComputeEndpoint;
    }

    /**
     * Set the graphApiComputeEndpoint property: GraphAPICompute endpoint for the service.
     * 
     * @param graphApiComputeEndpoint the graphApiComputeEndpoint value to set.
     * @return the GraphApiComputeServiceResourceProperties object itself.
     */
    public GraphApiComputeServiceResourceProperties withGraphApiComputeEndpoint(String graphApiComputeEndpoint) {
        this.graphApiComputeEndpoint = graphApiComputeEndpoint;
        return this;
    }

    /**
     * Get the locations property: An array that contains all of the locations for the service.
     * 
     * @return the locations value.
     */
    public List<GraphApiComputeRegionalServiceResource> locations() {
        return this.locations;
    }

    /**
     * Get the creationTime property: Time of the last state change (ISO-8601 format).
     * 
     * @return the creationTime value.
     */
    @Override
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get the status property: Describes the status of a service.
     * 
     * @return the status value.
     */
    @Override
    public ServiceStatus status() {
        return this.status;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphApiComputeServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphApiComputeServiceResourceProperties withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (locations() != null) {
            locations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", instanceSize() == null ? null : instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("graphApiComputeEndpoint", this.graphApiComputeEndpoint);
        if (additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphApiComputeServiceResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphApiComputeServiceResourceProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GraphApiComputeServiceResourceProperties.
     */
    public static GraphApiComputeServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphApiComputeServiceResourceProperties deserializedGraphApiComputeServiceResourceProperties
                = new GraphApiComputeServiceResourceProperties();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("creationTime".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("instanceSize".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties
                        .withInstanceSize(ServiceSize.fromString(reader.getString()));
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties
                        .withInstanceCount(reader.getNullable(JsonReader::getInt));
                } else if ("status".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.status
                        = ServiceStatus.fromString(reader.getString());
                } else if ("serviceType".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.serviceType
                        = ServiceType.fromString(reader.getString());
                } else if ("graphApiComputeEndpoint".equals(fieldName)) {
                    deserializedGraphApiComputeServiceResourceProperties.graphApiComputeEndpoint = reader.getString();
                } else if ("locations".equals(fieldName)) {
                    List<GraphApiComputeRegionalServiceResource> locations
                        = reader.readArray(reader1 -> GraphApiComputeRegionalServiceResource.fromJson(reader1));
                    deserializedGraphApiComputeServiceResourceProperties.locations = locations;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedGraphApiComputeServiceResourceProperties.withAdditionalProperties(additionalProperties);

            return deserializedGraphApiComputeServiceResourceProperties;
        });
    }
}
