// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The object representing continuous mode backup policy.
 */
@Fluent
public final class ContinuousModeBackupPolicy extends BackupPolicy {
    /*
     * Describes the mode of backups.
     */
    private BackupPolicyType type = BackupPolicyType.CONTINUOUS;

    /*
     * Configuration values for continuous mode backup
     */
    private ContinuousModeProperties continuousModeProperties;

    /**
     * Creates an instance of ContinuousModeBackupPolicy class.
     */
    public ContinuousModeBackupPolicy() {
    }

    /**
     * Get the type property: Describes the mode of backups.
     * 
     * @return the type value.
     */
    @Override
    public BackupPolicyType type() {
        return this.type;
    }

    /**
     * Get the continuousModeProperties property: Configuration values for continuous mode backup.
     * 
     * @return the continuousModeProperties value.
     */
    public ContinuousModeProperties continuousModeProperties() {
        return this.continuousModeProperties;
    }

    /**
     * Set the continuousModeProperties property: Configuration values for continuous mode backup.
     * 
     * @param continuousModeProperties the continuousModeProperties value to set.
     * @return the ContinuousModeBackupPolicy object itself.
     */
    public ContinuousModeBackupPolicy withContinuousModeProperties(ContinuousModeProperties continuousModeProperties) {
        this.continuousModeProperties = continuousModeProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ContinuousModeBackupPolicy withMigrationState(BackupPolicyMigrationState migrationState) {
        super.withMigrationState(migrationState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (continuousModeProperties() != null) {
            continuousModeProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("migrationState", migrationState());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("continuousModeProperties", this.continuousModeProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContinuousModeBackupPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContinuousModeBackupPolicy if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContinuousModeBackupPolicy.
     */
    public static ContinuousModeBackupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContinuousModeBackupPolicy deserializedContinuousModeBackupPolicy = new ContinuousModeBackupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("migrationState".equals(fieldName)) {
                    deserializedContinuousModeBackupPolicy
                        .withMigrationState(BackupPolicyMigrationState.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedContinuousModeBackupPolicy.type = BackupPolicyType.fromString(reader.getString());
                } else if ("continuousModeProperties".equals(fieldName)) {
                    deserializedContinuousModeBackupPolicy.continuousModeProperties
                        = ContinuousModeProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContinuousModeBackupPolicy;
        });
    }
}
