// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The CassandraTableGetPropertiesResource model.
 */
@Fluent
public final class CassandraTableGetPropertiesResource extends CassandraTableResource {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of CassandraTableGetPropertiesResource class.
     */
    public CassandraTableGetPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableGetPropertiesResource withSchema(CassandraSchema schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableGetPropertiesResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeNumberField("defaultTtl", defaultTtl());
        jsonWriter.writeJsonField("schema", schema());
        jsonWriter.writeNumberField("analyticalStorageTtl", analyticalStorageTtl());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraTableGetPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraTableGetPropertiesResource if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CassandraTableGetPropertiesResource.
     */
    public static CassandraTableGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraTableGetPropertiesResource deserializedCassandraTableGetPropertiesResource
                = new CassandraTableGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withId(reader.getString());
                } else if ("defaultTtl".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource
                        .withDefaultTtl(reader.getNullable(JsonReader::getInt));
                } else if ("schema".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withSchema(CassandraSchema.fromJson(reader));
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource
                        .withAnalyticalStorageTtl(reader.getNullable(JsonReader::getInt));
                } else if ("_rid".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraTableGetPropertiesResource;
        });
    }
}
