// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ApiProperties model.
 */
@Fluent
public final class ApiProperties implements JsonSerializable<ApiProperties> {
    /*
     * Describes the ServerVersion of an a MongoDB account.
     */
    private ServerVersion serverVersion;

    /**
     * Creates an instance of ApiProperties class.
     */
    public ApiProperties() {
    }

    /**
     * Get the serverVersion property: Describes the ServerVersion of an a MongoDB account.
     * 
     * @return the serverVersion value.
     */
    public ServerVersion serverVersion() {
        return this.serverVersion;
    }

    /**
     * Set the serverVersion property: Describes the ServerVersion of an a MongoDB account.
     * 
     * @param serverVersion the serverVersion value to set.
     * @return the ApiProperties object itself.
     */
    public ApiProperties withServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverVersion", this.serverVersion == null ? null : this.serverVersion.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiProperties.
     */
    public static ApiProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiProperties deserializedApiProperties = new ApiProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serverVersion".equals(fieldName)) {
                    deserializedApiProperties.serverVersion = ServerVersion.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiProperties;
        });
    }
}
