// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import java.io.IOException;

/**
 * A notebook workspace resource.
 */
@Immutable
public final class NotebookWorkspaceInner extends ArmProxyResource {
    /*
     * Resource properties.
     */
    private NotebookWorkspaceProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of NotebookWorkspaceInner class.
     */
    public NotebookWorkspaceInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private NotebookWorkspaceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the notebookServerEndpoint property: Specifies the endpoint of Notebook server.
     * 
     * @return the notebookServerEndpoint value.
     */
    public String notebookServerEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().notebookServerEndpoint();
    }

    /**
     * Get the status property: Status of the notebook workspace. Possible values are: Creating, Online, Deleting,
     * Failed, Updating.
     * 
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NotebookWorkspaceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NotebookWorkspaceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NotebookWorkspaceInner.
     */
    public static NotebookWorkspaceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NotebookWorkspaceInner deserializedNotebookWorkspaceInner = new NotebookWorkspaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNotebookWorkspaceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNotebookWorkspaceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNotebookWorkspaceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNotebookWorkspaceInner.innerProperties = NotebookWorkspaceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNotebookWorkspaceInner;
        });
    }
}
