// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

/**
 * An Azure Cosmos DB MongoDB database.
 */
@Fluent
public final class MongoDBDatabaseGetResultsInner extends ArmResourceProperties {
    /*
     * The properties of an Azure Cosmos DB MongoDB database
     */
    private MongoDBDatabaseGetProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of MongoDBDatabaseGetResultsInner class.
     */
    public MongoDBDatabaseGetResultsInner() {
    }

    /**
     * Get the innerProperties property: The properties of an Azure Cosmos DB MongoDB database.
     * 
     * @return the innerProperties value.
     */
    private MongoDBDatabaseGetProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBDatabaseGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBDatabaseGetResultsInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public MongoDBDatabaseGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the MongoDBDatabaseGetResultsInner object itself.
     */
    public MongoDBDatabaseGetResultsInner withResource(MongoDBDatabaseGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBDatabaseGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Get the options property: The options property.
     * 
     * @return the options value.
     */
    public MongoDBDatabaseGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    /**
     * Set the options property: The options property.
     * 
     * @param options the options value to set.
     * @return the MongoDBDatabaseGetResultsInner object itself.
     */
    public MongoDBDatabaseGetResultsInner withOptions(MongoDBDatabaseGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoDBDatabaseGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoDBDatabaseGetResultsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoDBDatabaseGetResultsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MongoDBDatabaseGetResultsInner.
     */
    public static MongoDBDatabaseGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoDBDatabaseGetResultsInner deserializedMongoDBDatabaseGetResultsInner
                = new MongoDBDatabaseGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBDatabaseGetResultsInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedMongoDBDatabaseGetResultsInner.innerProperties
                        = MongoDBDatabaseGetProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMongoDBDatabaseGetResultsInner;
        });
    }
}
