// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.LocationProperties;
import java.io.IOException;

/**
 * Cosmos DB location get result.
 */
@Fluent
public final class LocationGetResultInner extends ArmProxyResource {
    /*
     * Cosmos DB location metadata
     */
    private LocationProperties properties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of LocationGetResultInner class.
     */
    public LocationGetResultInner() {
    }

    /**
     * Get the properties property: Cosmos DB location metadata.
     * 
     * @return the properties value.
     */
    public LocationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Cosmos DB location metadata.
     * 
     * @param properties the properties value to set.
     * @return the LocationGetResultInner object itself.
     */
    public LocationGetResultInner withProperties(LocationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocationGetResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocationGetResultInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LocationGetResultInner.
     */
    public static LocationGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocationGetResultInner deserializedLocationGetResultInner = new LocationGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLocationGetResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLocationGetResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLocationGetResultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLocationGetResultInner.properties = LocationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocationGetResultInner;
        });
    }
}
