// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The read-only access keys for the given database account.
 */
@Immutable
public class DatabaseAccountListReadOnlyKeysResultInner
    implements JsonSerializable<DatabaseAccountListReadOnlyKeysResultInner> {
    /*
     * Base 64 encoded value of the primary read-only key.
     */
    private String primaryReadonlyMasterKey;

    /*
     * Base 64 encoded value of the secondary read-only key.
     */
    private String secondaryReadonlyMasterKey;

    /**
     * Creates an instance of DatabaseAccountListReadOnlyKeysResultInner class.
     */
    public DatabaseAccountListReadOnlyKeysResultInner() {
    }

    /**
     * Get the primaryReadonlyMasterKey property: Base 64 encoded value of the primary read-only key.
     * 
     * @return the primaryReadonlyMasterKey value.
     */
    public String primaryReadonlyMasterKey() {
        return this.primaryReadonlyMasterKey;
    }

    /**
     * Set the primaryReadonlyMasterKey property: Base 64 encoded value of the primary read-only key.
     * 
     * @param primaryReadonlyMasterKey the primaryReadonlyMasterKey value to set.
     * @return the DatabaseAccountListReadOnlyKeysResultInner object itself.
     */
    DatabaseAccountListReadOnlyKeysResultInner withPrimaryReadonlyMasterKey(String primaryReadonlyMasterKey) {
        this.primaryReadonlyMasterKey = primaryReadonlyMasterKey;
        return this;
    }

    /**
     * Get the secondaryReadonlyMasterKey property: Base 64 encoded value of the secondary read-only key.
     * 
     * @return the secondaryReadonlyMasterKey value.
     */
    public String secondaryReadonlyMasterKey() {
        return this.secondaryReadonlyMasterKey;
    }

    /**
     * Set the secondaryReadonlyMasterKey property: Base 64 encoded value of the secondary read-only key.
     * 
     * @param secondaryReadonlyMasterKey the secondaryReadonlyMasterKey value to set.
     * @return the DatabaseAccountListReadOnlyKeysResultInner object itself.
     */
    DatabaseAccountListReadOnlyKeysResultInner withSecondaryReadonlyMasterKey(String secondaryReadonlyMasterKey) {
        this.secondaryReadonlyMasterKey = secondaryReadonlyMasterKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAccountListReadOnlyKeysResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAccountListReadOnlyKeysResultInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseAccountListReadOnlyKeysResultInner.
     */
    public static DatabaseAccountListReadOnlyKeysResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAccountListReadOnlyKeysResultInner deserializedDatabaseAccountListReadOnlyKeysResultInner
                = new DatabaseAccountListReadOnlyKeysResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primaryReadonlyMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountListReadOnlyKeysResultInner.primaryReadonlyMasterKey
                        = reader.getString();
                } else if ("secondaryReadonlyMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountListReadOnlyKeysResultInner.secondaryReadonlyMasterKey
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAccountListReadOnlyKeysResultInner;
        });
    }
}
