// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionKeyGetPropertiesResource;
import java.io.IOException;

/**
 * Client Encryption Key.
 */
@Fluent
public final class ClientEncryptionKeyGetResultsInner extends ArmProxyResource {
    /*
     * The properties of a ClientEncryptionKey
     */
    private ClientEncryptionKeyGetProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ClientEncryptionKeyGetResultsInner class.
     */
    public ClientEncryptionKeyGetResultsInner() {
    }

    /**
     * Get the innerProperties property: The properties of a ClientEncryptionKey.
     * 
     * @return the innerProperties value.
     */
    private ClientEncryptionKeyGetProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public ClientEncryptionKeyGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the ClientEncryptionKeyGetResultsInner object itself.
     */
    public ClientEncryptionKeyGetResultsInner withResource(ClientEncryptionKeyGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientEncryptionKeyGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientEncryptionKeyGetResultsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientEncryptionKeyGetResultsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ClientEncryptionKeyGetResultsInner.
     */
    public static ClientEncryptionKeyGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientEncryptionKeyGetResultsInner deserializedClientEncryptionKeyGetResultsInner
                = new ClientEncryptionKeyGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetResultsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetResultsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetResultsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetResultsInner.innerProperties
                        = ClientEncryptionKeyGetProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientEncryptionKeyGetResultsInner;
        });
    }
}
