// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Parameters for Create or Update request for MaterializedViewsBuilderServiceResource.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "serviceType",
    defaultImpl = MaterializedViewsBuilderServiceResourceCreateUpdateParameters.class,
    visible = true)
@JsonTypeName("MaterializedViewsBuilder")
@Fluent
public final class MaterializedViewsBuilderServiceResourceCreateUpdateParameters
    extends ServiceResourceCreateUpdateProperties {
    /*
     * ServiceType for the service.
     */
    @JsonTypeId
    @JsonProperty(value = "serviceType", required = true)
    private ServiceType serviceType = ServiceType.MATERIALIZED_VIEWS_BUILDER;

    /**
     * Creates an instance of MaterializedViewsBuilderServiceResourceCreateUpdateParameters class.
     */
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MaterializedViewsBuilderServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
