// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Parameters for Create or Update request for GraphAPIComputeServiceResource.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "serviceType",
    defaultImpl = GraphApiComputeServiceResourceCreateUpdateParameters.class,
    visible = true)
@JsonTypeName("GraphAPICompute")
@Fluent
public final class GraphApiComputeServiceResourceCreateUpdateParameters extends ServiceResourceCreateUpdateProperties {
    /*
     * ServiceType for the service.
     */
    @JsonTypeId
    @JsonProperty(value = "serviceType", required = true)
    private ServiceType serviceType = ServiceType.GRAPH_APICOMPUTE;

    /**
     * Creates an instance of GraphApiComputeServiceResourceCreateUpdateParameters class.
     */
    public GraphApiComputeServiceResourceCreateUpdateParameters() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphApiComputeServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphApiComputeServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
