// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The object representing continuous mode backup policy.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = ContinuousModeBackupPolicy.class,
    visible = true)
@JsonTypeName("Continuous")
@Fluent
public final class ContinuousModeBackupPolicy extends BackupPolicy {
    /*
     * Describes the mode of backups.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private BackupPolicyType type = BackupPolicyType.CONTINUOUS;

    /*
     * Configuration values for continuous mode backup
     */
    @JsonProperty(value = "continuousModeProperties")
    private ContinuousModeProperties continuousModeProperties;

    /**
     * Creates an instance of ContinuousModeBackupPolicy class.
     */
    public ContinuousModeBackupPolicy() {
    }

    /**
     * Get the type property: Describes the mode of backups.
     * 
     * @return the type value.
     */
    @Override
    public BackupPolicyType type() {
        return this.type;
    }

    /**
     * Get the continuousModeProperties property: Configuration values for continuous mode backup.
     * 
     * @return the continuousModeProperties value.
     */
    public ContinuousModeProperties continuousModeProperties() {
        return this.continuousModeProperties;
    }

    /**
     * Set the continuousModeProperties property: Configuration values for continuous mode backup.
     * 
     * @param continuousModeProperties the continuousModeProperties value to set.
     * @return the ContinuousModeBackupPolicy object itself.
     */
    public ContinuousModeBackupPolicy withContinuousModeProperties(ContinuousModeProperties continuousModeProperties) {
        this.continuousModeProperties = continuousModeProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ContinuousModeBackupPolicy withMigrationState(BackupPolicyMigrationState migrationState) {
        super.withMigrationState(migrationState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (continuousModeProperties() != null) {
            continuousModeProperties().validate();
        }
    }
}
