// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Cosmos DB Cassandra keyspace resource object.
 */
@Fluent
public class CassandraKeyspaceResource {
    /*
     * Name of the Cosmos DB Cassandra keyspace
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * Creates an instance of CassandraKeyspaceResource class.
     */
    public CassandraKeyspaceResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB Cassandra keyspace.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB Cassandra keyspace.
     * 
     * @param id the id value to set.
     * @return the CassandraKeyspaceResource object itself.
     */
    public CassandraKeyspaceResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model CassandraKeyspaceResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CassandraKeyspaceResource.class);
}
