// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;

/**
 * How to connect to the azure services needed for running the cluster.
 */
public final class AzureConnectionType extends ExpandableStringEnum<AzureConnectionType> {
    /**
     * Static value None for AzureConnectionType.
     */
    public static final AzureConnectionType NONE = fromString("None");

    /**
     * Static value VPN for AzureConnectionType.
     */
    public static final AzureConnectionType VPN = fromString("VPN");

    /**
     * Creates a new instance of AzureConnectionType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AzureConnectionType() {
    }

    /**
     * Creates or finds a AzureConnectionType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureConnectionType.
     */
    @JsonCreator
    public static AzureConnectionType fromString(String name) {
        return fromString(name, AzureConnectionType.class);
    }

    /**
     * Gets known AzureConnectionType values.
     *
     * @return known AzureConnectionType values.
     */
    public static Collection<AzureConnectionType> values() {
        return values(AzureConnectionType.class);
    }
}
